IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_PROD_CPL_VD_LOTE_PROC_PENDENTE') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PROD_CPL_VD_LOTE_PROC_PENDENTE](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_CTR_DT_MOVIMENTO] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PROD_CPL_VD_LOTE_PROC_PENDENTE] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_CPL_VD_LOTE_PROC_PENDENTE] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR_DT_MOVIMENTO]  DEFAULT ((0)) FOR [CD_CTR_DT_MOVIMENTO]

ALTER TABLE [dbo].[EST_PROD_CPL_VD_LOTE_PROC_PENDENTE] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PROD_CPL_VD_LOTE_PROC_PENDENTE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_GLB_DT_MOVIMENTO] FOREIGN KEY([CD_CTR_DT_MOVIMENTO])
REFERENCES [dbo].[GLB_DT_MOVIMENTO] ([CD_CTR_DT_MOVIMENTO])

ALTER TABLE [dbo].[EST_PROD_CPL_VD_LOTE_PROC_PENDENTE] CHECK CONSTRAINT [FK_EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_GLB_DT_MOVIMENTO]
end